using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Summary description for AntibodyID.
	/// </summary>
	public class AntibodyID : GUI.controls.BaseControl
	{

		#region Controls

		private System.Windows.Forms.GroupBox grpComments;
		private System.Windows.Forms.TextBox txtDetails;
		private System.Windows.Forms.Label lblDetails;
		private System.Windows.Forms.Label lblComment;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpAntibodyID;
		private System.Windows.Forms.CheckBox cbNoAntibody;
		private System.Windows.Forms.CheckedListBox lstAntibodyID;
		private System.Windows.Forms.TextBox txtAntibodyID;
		private System.Windows.Forms.GroupBox grpOnSite;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbWorkloadProcess;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updMultiples;
		private System.Windows.Forms.Button btnAdd;
		private System.Windows.Forms.ListView lvWorkloadProcesses;
		private System.Windows.Forms.Label lblMultiples;
		private System.Windows.Forms.Label lblWorkloadProcess;
		private System.Windows.Forms.CheckBox cbOnSite;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.GroupBox grpOffSite;
		private System.Windows.Forms.Panel pnlOffSite;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updCost;
		private System.Windows.Forms.Label lblCost;
		private System.Windows.Forms.TextBox txtLocation;
		private System.Windows.Forms.Label lblLocation;
		private System.Windows.Forms.CheckBox cbOffSite;
		private System.ComponentModel.IContainer components;

		#endregion

		#region Variables


		private DataTable _dtAntibodies;
		private DataTable _dtVbecsProcesses;
		private DataTable _dtCannedComments;
		private DataTable _dtAntibodyIDs;
		private ArrayList _workloadProcessIds;
		private BOL.OrderedTest _orderedTest;
		private BOL.Division _division;
		private int _selectedAntibodies;
		private gov.va.med.vbecs.GUI.controls.VbecsErrorProvider errError; // **** 508 Compliance ***
		private int _selectedProcesses;
		private bool _validMultiplier;

		#endregion

		/// <summary>
		/// DataChanged
		/// </summary>
		public event CellChangedEventHandler DataChanged;

		#region Constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public AntibodyID()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			_selectedAntibodies = 0;
			_selectedProcesses = 0;
			this.txtAntibodyID.Text = "Anti-";
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(AntibodyID));
			this.grpComments = new System.Windows.Forms.GroupBox();
			this.txtDetails = new System.Windows.Forms.TextBox();
			this.lblDetails = new System.Windows.Forms.Label();
			this.lblComment = new System.Windows.Forms.Label();
			this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpAntibodyID = new System.Windows.Forms.GroupBox();
			this.cbNoAntibody = new System.Windows.Forms.CheckBox();
			this.lstAntibodyID = new System.Windows.Forms.CheckedListBox();
			this.txtAntibodyID = new System.Windows.Forms.TextBox();
			this.grpOnSite = new System.Windows.Forms.GroupBox();
			this.cmbWorkloadProcess = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.updMultiples = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.btnAdd = new System.Windows.Forms.Button();
			this.lvWorkloadProcesses = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.lblMultiples = new System.Windows.Forms.Label();
			this.lblWorkloadProcess = new System.Windows.Forms.Label();
			this.cbOnSite = new System.Windows.Forms.CheckBox();
			this.grpOffSite = new System.Windows.Forms.GroupBox();
			this.pnlOffSite = new System.Windows.Forms.Panel();
			this.updCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblCost = new System.Windows.Forms.Label();
			this.txtLocation = new System.Windows.Forms.TextBox();
			this.lblLocation = new System.Windows.Forms.Label();
			this.cbOffSite = new System.Windows.Forms.CheckBox();
			this.errError = new gov.va.med.vbecs.GUI.controls.VbecsErrorProvider();
			this.grpComments.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpAntibodyID.SuspendLayout();
			this.grpOnSite.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updMultiples)).BeginInit();
			this.grpOffSite.SuspendLayout();
			this.pnlOffSite.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updCost)).BeginInit();
			this.SuspendLayout();
			// 
			// grpComments
			// 
			this.grpComments.AccessibleDescription = "Antibody I D Testing Comments";
			this.grpComments.AccessibleName = "Antibody I D Testing Comments";
			this.grpComments.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpComments.Controls.Add(this.txtDetails);
			this.grpComments.Controls.Add(this.lblDetails);
			this.grpComments.Controls.Add(this.lblComment);
			this.grpComments.Controls.Add(this.cmbComment);
			this.grpComments.Enabled = false;
			this.grpComments.Location = new System.Drawing.Point(40, 284);
			this.grpComments.Name = "grpComments";
			this.grpComments.Size = new System.Drawing.Size(272, 80);
			this.grpComments.TabIndex = 4;
			this.grpComments.TabStop = false;
			this.grpComments.Text = "Antibody ID Testing Comments";
			// 
			// txtDetails
			// 
			this.txtDetails.AccessibleDescription = "Details";
			this.txtDetails.AccessibleName = "Details";
			this.txtDetails.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDetails.Location = new System.Drawing.Point(64, 40);
			this.txtDetails.MaxLength = 255;
			this.txtDetails.Multiline = true;
			this.txtDetails.Name = "txtDetails";
			this.txtDetails.Size = new System.Drawing.Size(200, 32);
			this.txtDetails.TabIndex = 5;
			this.txtDetails.Text = "";
			// 
			// lblDetails
			// 
			this.lblDetails.Location = new System.Drawing.Point(8, 40);
			this.lblDetails.Name = "lblDetails";
			this.lblDetails.Size = new System.Drawing.Size(56, 20);
			this.lblDetails.TabIndex = 72;
			this.lblDetails.Text = "Details";
			this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblComment
			// 
			this.lblComment.Location = new System.Drawing.Point(8, 16);
			this.lblComment.Name = "lblComment";
			this.lblComment.Size = new System.Drawing.Size(56, 20);
			this.lblComment.TabIndex = 71;
			this.lblComment.Text = "Comment";
			this.lblComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbComment
			// 
			this.cmbComment.AccessibleDescription = "Comments";
			this.cmbComment.AccessibleName = "Comments";
			this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbComment.DropDownWidth = 204;
			this.cmbComment.Interval = 1000;
			this.cmbComment.Location = new System.Drawing.Point(64, 16);
			this.cmbComment.MaxLength = 80;
			this.cmbComment.Name = "cmbComment";
			this.cmbComment.Size = new System.Drawing.Size(200, 22);
			this.cmbComment.TabIndex = 4;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(0, 0);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(36, 364);
			this.grpImage.TabIndex = 61;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(28, 28);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpAntibodyID
			// 
			this.grpAntibodyID.AccessibleDescription = "Antibodies Identified";
			this.grpAntibodyID.AccessibleName = "Antibodies Identified";
			this.grpAntibodyID.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpAntibodyID.BackColor = System.Drawing.SystemColors.Control;
			this.grpAntibodyID.Controls.Add(this.cbNoAntibody);
			this.grpAntibodyID.Controls.Add(this.lstAntibodyID);
			this.grpAntibodyID.Controls.Add(this.txtAntibodyID);
			this.grpAntibodyID.Location = new System.Drawing.Point(40, 0);
			this.grpAntibodyID.Name = "grpAntibodyID";
			this.grpAntibodyID.Size = new System.Drawing.Size(272, 280);
			this.grpAntibodyID.TabIndex = 0;
			this.grpAntibodyID.TabStop = false;
			this.grpAntibodyID.Text = "Antibodies Identified*";
			// 
			// cbNoAntibody
			// 
			this.cbNoAntibody.AccessibleDescription = "No antibody was identified.";
			this.cbNoAntibody.AccessibleName = "No antibody was identified.";
			this.cbNoAntibody.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbNoAntibody.Location = new System.Drawing.Point(11, 260);
			this.cbNoAntibody.Name = "cbNoAntibody";
			this.cbNoAntibody.Size = new System.Drawing.Size(248, 16);
			this.cbNoAntibody.TabIndex = 3;
			this.cbNoAntibody.Text = "&No antibody was identified.";
			this.cbNoAntibody.CheckedChanged += new System.EventHandler(this.cbNoAntibody_CheckedChanged);
			// 
			// lstAntibodyID
			// 
			this.lstAntibodyID.AccessibleDescription = "Antibodies Identified";
			this.lstAntibodyID.AccessibleName = "Antibodies Identified";
			this.lstAntibodyID.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lstAntibodyID.ColumnWidth = 200;
			this.lstAntibodyID.Location = new System.Drawing.Point(8, 36);
			this.lstAntibodyID.MultiColumn = true;
			this.lstAntibodyID.Name = "lstAntibodyID";
			this.lstAntibodyID.Size = new System.Drawing.Size(256, 214);
			this.lstAntibodyID.TabIndex = 2;
			this.lstAntibodyID.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lstAntibodyID_ItemCheck);
			// 
			// txtAntibodyID
			// 
			this.txtAntibodyID.AccessibleDescription = "Antibodies Identified";
			this.txtAntibodyID.AccessibleName = "Antibodies Identified";
			this.txtAntibodyID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAntibodyID.Location = new System.Drawing.Point(8, 16);
			this.txtAntibodyID.Name = "txtAntibodyID";
			this.txtAntibodyID.Size = new System.Drawing.Size(256, 20);
			this.txtAntibodyID.TabIndex = 1;
			this.txtAntibodyID.Text = "";
			this.txtAntibodyID.TextChanged += new System.EventHandler(this.txtAntibodyID_TextChanged);
			// 
			// grpOnSite
			// 
			this.grpOnSite.AccessibleDescription = "Test Performed On-Site";
			this.grpOnSite.AccessibleName = "Test Performed On-Site";
			this.grpOnSite.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpOnSite.Controls.Add(this.cmbWorkloadProcess);
			this.grpOnSite.Controls.Add(this.updMultiples);
			this.grpOnSite.Controls.Add(this.btnAdd);
			this.grpOnSite.Controls.Add(this.lvWorkloadProcesses);
			this.grpOnSite.Controls.Add(this.lblMultiples);
			this.grpOnSite.Controls.Add(this.lblWorkloadProcess);
			this.grpOnSite.Enabled = false;
			this.grpOnSite.Location = new System.Drawing.Point(316, 52);
			this.grpOnSite.Name = "grpOnSite";
			this.grpOnSite.Size = new System.Drawing.Size(320, 312);
			this.grpOnSite.TabIndex = 5;
			this.grpOnSite.TabStop = false;
			// 
			// cmbWorkloadProcess
			// 
			this.cmbWorkloadProcess.AccessibleDescription = "Workload Process";
			this.cmbWorkloadProcess.AccessibleName = "Workload Process";
			this.cmbWorkloadProcess.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbWorkloadProcess.DropDownWidth = 204;
			this.cmbWorkloadProcess.Interval = 1000;
			this.cmbWorkloadProcess.Location = new System.Drawing.Point(104, 16);
			this.cmbWorkloadProcess.MaxLength = 500;
			this.cmbWorkloadProcess.Name = "cmbWorkloadProcess";
			this.cmbWorkloadProcess.Size = new System.Drawing.Size(200, 22);
			this.cmbWorkloadProcess.TabIndex = 10;
			this.cmbWorkloadProcess.SelectedIndexChanged += new System.EventHandler(this.cmbWorkloadProcess_SelectedIndexChanged);
			// 
			// updMultiples
			// 
			this.updMultiples.AccessibleDescription = "Multiplier";
			this.updMultiples.AccessibleName = "Multiplier";
			this.updMultiples.Location = new System.Drawing.Point(104, 40);
			this.updMultiples.Minimum = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 0});
			this.updMultiples.Name = "updMultiples";
			this.updMultiples.Size = new System.Drawing.Size(48, 20);
			this.updMultiples.TabIndex = 11;
			this.updMultiples.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updMultiples.Value = new System.Decimal(new int[] {
																	   1,
																	   0,
																	   0,
																	   0});
			this.updMultiples.TextChanged += new System.EventHandler(this.updMultiples_TextChanged);
			this.updMultiples.Leave += new System.EventHandler(this.updMultiples_Leave);
			this.updMultiples.ValueChanged += new System.EventHandler(this.updMultiples_TextChanged);
			// 
			// btnAdd
			// 
			this.btnAdd.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAdd.Image = ((System.Drawing.Image)(resources.GetObject("btnAdd.Image")));
			this.btnAdd.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnAdd.Location = new System.Drawing.Point(228, 40);
			this.btnAdd.Name = "btnAdd";
			this.btnAdd.TabIndex = 12;
			this.btnAdd.Text = "Add";
			this.btnAdd.Click += new System.EventHandler(this.btnAdd_Click);
			// 
			// lvWorkloadProcesses
			// 
			this.lvWorkloadProcesses.AccessibleDescription = "Workload Processes";
			this.lvWorkloadProcesses.AccessibleName = "Workload Processes";
			this.lvWorkloadProcesses.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvWorkloadProcesses.CheckBoxes = true;
			this.lvWorkloadProcesses.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																								  this.columnHeader1,
																								  this.columnHeader2,
																								  this.columnHeader3});
			this.lvWorkloadProcesses.FullRowSelect = true;
			this.lvWorkloadProcesses.Location = new System.Drawing.Point(8, 68);
			this.lvWorkloadProcesses.MultiSelect = false;
			this.lvWorkloadProcesses.Name = "lvWorkloadProcesses";
			this.lvWorkloadProcesses.Size = new System.Drawing.Size(304, 236);
			this.lvWorkloadProcesses.TabIndex = 13;
			this.lvWorkloadProcesses.View = System.Windows.Forms.View.Details;
			this.lvWorkloadProcesses.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvWorkloadProcesses_ItemCheck);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "";
			this.columnHeader1.Width = 30;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Workload Process";
			this.columnHeader2.Width = 190;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Multiplier";
			// 
			// lblMultiples
			// 
			this.lblMultiples.Location = new System.Drawing.Point(8, 40);
			this.lblMultiples.Name = "lblMultiples";
			this.lblMultiples.Size = new System.Drawing.Size(92, 20);
			this.lblMultiples.TabIndex = 70;
			this.lblMultiples.Text = "Multiplier*";
			this.lblMultiples.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblWorkloadProcess
			// 
			this.lblWorkloadProcess.Location = new System.Drawing.Point(8, 16);
			this.lblWorkloadProcess.Name = "lblWorkloadProcess";
			this.lblWorkloadProcess.Size = new System.Drawing.Size(100, 20);
			this.lblWorkloadProcess.TabIndex = 15;
			this.lblWorkloadProcess.Text = "Workload Process*";
			this.lblWorkloadProcess.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbOnSite
			// 
			this.cbOnSite.AccessibleDescription = "Test Performed On Site";
			this.cbOnSite.AccessibleName = "Test Performed On Site";
			this.cbOnSite.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cbOnSite.Location = new System.Drawing.Point(320, 48);
			this.cbOnSite.Name = "cbOnSite";
			this.cbOnSite.Size = new System.Drawing.Size(152, 20);
			this.cbOnSite.TabIndex = 9;
			this.cbOnSite.Text = "Test &Performed On-Site";
			this.cbOnSite.CheckedChanged += new System.EventHandler(this.cbOnSite_CheckedChanged);
			// 
			// grpOffSite
			// 
			this.grpOffSite.AccessibleDescription = "Test Performed Off-Site";
			this.grpOffSite.AccessibleName = "Test Performed Off-Site";
			this.grpOffSite.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.grpOffSite.Controls.Add(this.pnlOffSite);
			this.grpOffSite.Enabled = false;
			this.grpOffSite.Location = new System.Drawing.Point(316, 0);
			this.grpOffSite.Name = "grpOffSite";
			this.grpOffSite.Size = new System.Drawing.Size(320, 48);
			this.grpOffSite.TabIndex = 3;
			this.grpOffSite.TabStop = false;
			// 
			// pnlOffSite
			// 
			this.pnlOffSite.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlOffSite.Controls.Add(this.updCost);
			this.pnlOffSite.Controls.Add(this.lblCost);
			this.pnlOffSite.Controls.Add(this.txtLocation);
			this.pnlOffSite.Controls.Add(this.lblLocation);
			this.pnlOffSite.Location = new System.Drawing.Point(4, 16);
			this.pnlOffSite.Name = "pnlOffSite";
			this.pnlOffSite.Size = new System.Drawing.Size(314, 28);
			this.pnlOffSite.TabIndex = 3;
			// 
			// updCost
			// 
			this.updCost.AccessibleDescription = "Cost";
			this.updCost.AccessibleName = "Cost";
			this.updCost.DecimalPlaces = 2;
			this.updCost.Location = new System.Drawing.Point(240, 4);
			this.updCost.Maximum = new System.Decimal(new int[] {
																	999,
																	0,
																	0,
																	0});
			this.updCost.Name = "updCost";
			this.updCost.Size = new System.Drawing.Size(60, 20);
			this.updCost.TabIndex = 8;
			this.updCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updCost.Value = new System.Decimal(new int[] {
																  0,
																  0,
																  0,
																  0});
			this.updCost.TextChanged += new System.EventHandler(this.updCost_ValueChanged);
			this.updCost.Leave += new System.EventHandler(this.updCost_Leave);
			this.updCost.ValueChanged += new System.EventHandler(this.updCost_ValueChanged);
			// 
			// lblCost
			// 
			this.lblCost.Location = new System.Drawing.Point(192, 4);
			this.lblCost.Name = "lblCost";
			this.lblCost.Size = new System.Drawing.Size(52, 20);
			this.lblCost.TabIndex = 4;
			this.lblCost.Text = "Cost* ($)";
			this.lblCost.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtLocation
			// 
			this.txtLocation.AccessibleDescription = "Location";
			this.txtLocation.AccessibleName = "Location";
			this.txtLocation.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtLocation.Location = new System.Drawing.Point(60, 4);
			this.txtLocation.Name = "txtLocation";
			this.txtLocation.Size = new System.Drawing.Size(126, 20);
			this.txtLocation.TabIndex = 7;
			this.txtLocation.Text = "";
			this.txtLocation.TextChanged += new System.EventHandler(this.txtLocation_TextChanged);
			// 
			// lblLocation
			// 
			this.lblLocation.Location = new System.Drawing.Point(4, 4);
			this.lblLocation.Name = "lblLocation";
			this.lblLocation.Size = new System.Drawing.Size(52, 20);
			this.lblLocation.TabIndex = 2;
			this.lblLocation.Text = "Location*";
			this.lblLocation.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbOffSite
			// 
			this.cbOffSite.AccessibleDescription = "Test Performed Off Site";
			this.cbOffSite.AccessibleName = "Test Performed Off Site";
			this.cbOffSite.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cbOffSite.Location = new System.Drawing.Point(320, 0);
			this.cbOffSite.Name = "cbOffSite";
			this.cbOffSite.Size = new System.Drawing.Size(152, 16);
			this.cbOffSite.TabIndex = 6;
			this.cbOffSite.Text = "Test Performed O&ff-Site";
			this.cbOffSite.CheckedChanged += new System.EventHandler(this.cbOffSite_CheckedChanged);
			// 
			// errError
			// 
			this.errError.ContainerControl = this;
			// 
			// AntibodyID
			// 
			this.Controls.Add(this.cbOffSite);
			this.Controls.Add(this.cbOnSite);
			this.Controls.Add(this.grpComments);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpAntibodyID);
			this.Controls.Add(this.grpOnSite);
			this.Controls.Add(this.grpOffSite);
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "AntibodyID";
			this.Size = new System.Drawing.Size(636, 364);
			this.grpComments.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpAntibodyID.ResumeLayout(false);
			this.grpOnSite.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updMultiples)).EndInit();
			this.grpOffSite.ResumeLayout(false);
			this.pnlOffSite.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updCost)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		#endregion

		#region Methods

		/// <summary>
		/// Initialize DataTables that are the data sources for antibody list, 
		/// vbecs process list and canned comment list. Populates screen with those data.
		/// </summary>
		public void Initialize()
		{
			LoadAntibodyList();
			LoadVbecsProcessList();
			LoadCannedCommentList();
			this._validMultiplier = true;
			this.txtAntibodyID.Select(this.txtAntibodyID.Text.Length, 0);
			this.txtAntibodyID.Focus();
			this._division = new BOL.Division(Common.LogonUser.LogonUserDivisionCode);
			if (this._division.ServiceTypeIndicator == false)
				this.cbOnSite.Enabled = false;
		}

		/// <summary>
		/// Invoke cell changed event
		/// </summary>
		/// <param name="e"></param>
		protected virtual void OnDataChanged(EventArgs e)
		{
			this.OnUserActivity();

			if (DataChanged != null)
				DataChanged(this, e);
		}

		/// <summary>
		/// Populate the list of all antibodies
		/// </summary>
		private void LoadAntibodyList()
		{
			_dtAntibodies = BOL.AntibodyType.GetAntibodiesWithoutAntigens();
			_dtAntibodies.CaseSensitive = true;
			
			foreach(DataRow drAntibody in _dtAntibodies.Rows)
			{
				if ((int)drAntibody[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 1 ||
					(int)drAntibody[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 4 ||
					(int)drAntibody[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 64 ||
					(int)drAntibody[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 49 ||
					(int)drAntibody[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 43 ||
					(int)drAntibody[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 32 ||
					(int)drAntibody[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 37 ||
					(int)drAntibody[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 36 ||
					(int)drAntibody[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 46 ||
					(int)drAntibody[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 23 ||
					(int)drAntibody[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 65 ||
					(int)drAntibody[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 66)
					continue;

				this.lstAntibodyID.Items.Add(drAntibody[TABLE.AntibodyType.AntibodyTypeName].ToString());
			}
		}

		/// <summary>
		/// Populate the list of Vbecs processes
		/// </summary>
		private void LoadVbecsProcessList()
		{
			_dtVbecsProcesses = BOL.WorkLoad.GetAllVbecsProcesses();

			foreach(DataRow drVbecsProcess in _dtVbecsProcesses.Rows)
			{
				this.cmbWorkloadProcess.Items.Add(drVbecsProcess[TABLE.VbecsProcess.VbecsProcessName].ToString());
			}
		}

		/// <summary>
		/// Populate the combo box containing the list of canned comments
		/// </summary>
		private void LoadCannedCommentList()
		{
			_dtCannedComments = BOL.CannedComment.GetCannedComments("PT");

			foreach(DataRow drCannedComment in _dtCannedComments.Rows)
			{
				this.cmbComment.Items.Add(drCannedComment[TABLE.CannedComment.CannedCommentText].ToString());
			}
		}


		/// <summary>
		/// Set the arraylist that keeps processes chosen for current testing. The list of 
		/// processes used for testing is being saved to the database and then sent to vista
		/// as a workload information for the test performed.
		/// </summary>
		/// <param name="workloadProcessIds" type="System.Collections.ArrayList">
		///     <para>
		///         
		///     </para>
		/// </param>
		/// <returns>
		///     A void value...
		/// </returns>
		public void SetAntibodyIDProcesses(ArrayList workloadProcessIds)
		{
			this._workloadProcessIds = workloadProcessIds;
		}

		/// <summary>
		/// Gets all the identified antibodies and processes and stores them in
		/// proper DataTables. The datatables containing antibody and process information
		/// are then being used by UC56 to save the result of the ABID test to database
		/// </summary>
		public void PrepareAntibodyIDsForSave()
		{
			if (this.cbNoAntibody.Checked == false)
			{
				foreach (object objAntibodyName in this.lstAntibodyID.CheckedItems)
				{
					if (this._dtAntibodies.Select(TABLE.AntibodyType.AntibodyTypeName +  " = '" + objAntibodyName.ToString().Trim() + "'").Length > 0)
					{
						DataRow drAntibodyID = this._dtAntibodyIDs.NewRow();
						drAntibodyID[TABLE.AntibodyType.AntibodyTypeId] = this._dtAntibodies.Select(TABLE.AntibodyType.AntibodyTypeName + " = '" + objAntibodyName.ToString().Trim() + "'")[0][TABLE.AntibodyType.AntibodyTypeId];
						drAntibodyID[TABLE.AntibodyType.AntibodyTypeName] = objAntibodyName.ToString().Trim();

						if (this.cbOffSite.Checked == true)
						{
							drAntibodyID[TABLE.SpecimenTest.OffsiteIndicator] = true;
							drAntibodyID[TABLE.SpecimenTest.OffsiteLocation] = this.txtLocation.Text.Trim();
							drAntibodyID[TABLE.SpecimenTest.OffsiteCost] = this.updCost.Value;
						}
						else
						{
							drAntibodyID[TABLE.SpecimenTest.OffsiteIndicator] = false;
						}

						if (this.cmbComment.SelectedIndex != -1)
						{
							drAntibodyID[TABLE.CannedComment.CannedCommentGuid] = this._dtCannedComments.Rows[this.cmbComment.SelectedIndex][TABLE.CannedComment.CannedCommentGuid];
							drAntibodyID[TABLE.SpecimenTest.TestComments] = this.cmbComment.Text.Trim() + ". " + this.txtDetails.Text.Trim();
						}
						else
						{
							drAntibodyID[TABLE.SpecimenTest.TestComments] = this.txtDetails.Text.Trim();
						}

						drAntibodyID[TABLE.SpecimenTest.OrderedTestGuid] = this._orderedTest.OrderedTestGuid;
						drAntibodyID[TABLE.SpecimenTest.PatientSpecimenGuid] = this._orderedTest.Specimen.SpecimenGuid;
						drAntibodyID[TABLE.OrderableTest.OrderableTestId] = this._orderedTest.OrderableTestId;
						drAntibodyID[TABLE.Patient.PatientGuid] = this._orderedTest.Patient.PatientGuid;
						drAntibodyID[ARTIFICIAL.OrderedTestRowVersion] = this._orderedTest.RowVersion;
						if (this._orderedTest.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
						{
							drAntibodyID[TABLE.SpecimenTest.CorrectedResultIndicator] = true;
						}
						else
						{
							drAntibodyID[TABLE.SpecimenTest.CorrectedResultIndicator] = false;
						}

						this._dtAntibodyIDs.Rows.Add(drAntibodyID);
					}
				}
			}
			else
			{
				DataRow drAntibodyID = this._dtAntibodyIDs.NewRow();
				drAntibodyID[TABLE.AntibodyType.AntibodyTypeId] = DBNull.Value;
				this._dtAntibodyIDs.Rows.Add(drAntibodyID);

				if (this.cbOffSite.Checked == true)
				{
					this._dtAntibodyIDs.Rows[0][TABLE.SpecimenTest.OffsiteIndicator] = true;
					this._dtAntibodyIDs.Rows[0][TABLE.SpecimenTest.OffsiteLocation] = this.txtLocation.Text.Trim();
					this._dtAntibodyIDs.Rows[0][TABLE.SpecimenTest.OffsiteCost] = this.updCost.Value;
				}
				else
				{
					this._dtAntibodyIDs.Rows[0][TABLE.SpecimenTest.OffsiteIndicator] = false;
				}

				if (this.cmbComment.SelectedIndex != -1)
				{
					this._dtAntibodyIDs.Rows[0][TABLE.CannedComment.CannedCommentGuid] = this._dtCannedComments.Rows[this.cmbComment.SelectedIndex][TABLE.CannedComment.CannedCommentGuid];
					this._dtAntibodyIDs.Rows[0][TABLE.SpecimenTest.TestComments] = this.cmbComment.Text.Trim() + ". " + this.txtDetails.Text.Trim();
				}
				else
				{
					this._dtAntibodyIDs.Rows[0][TABLE.SpecimenTest.TestComments] = this.txtDetails.Text.Trim();
				}

				this._dtAntibodyIDs.Rows[0][TABLE.SpecimenTest.OrderedTestGuid] = this._orderedTest.OrderedTestGuid;
				this._dtAntibodyIDs.Rows[0][TABLE.SpecimenTest.PatientSpecimenGuid] = this._orderedTest.Specimen.SpecimenGuid;
				this._dtAntibodyIDs.Rows[0][TABLE.OrderableTest.OrderableTestId] = this._orderedTest.OrderableTestId;
				this._dtAntibodyIDs.Rows[0][TABLE.Patient.PatientGuid] = this._orderedTest.Patient.PatientGuid;
				this._dtAntibodyIDs.Rows[0][ARTIFICIAL.OrderedTestRowVersion] = this._orderedTest.RowVersion;
				if (this._orderedTest.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
				{
					this._dtAntibodyIDs.Rows[0][TABLE.SpecimenTest.CorrectedResultIndicator] = true;
				}
				else
				{
					this._dtAntibodyIDs.Rows[0][TABLE.SpecimenTest.CorrectedResultIndicator] = false;
				}
			}

			foreach(ListViewItem lvItm in this.lvWorkloadProcesses.CheckedItems)
			{
				this._workloadProcessIds.Add((int) lvItm.Tag);
				this._workloadProcessIds.Add(System.Convert.ToInt32(lvItm.SubItems[2].Text));
			}
		}

		#endregion

		#region Properties

		/// <summary>
		/// Checks if the user entered the required data. If not the OK button is disabled
		/// so the user cannot save the results of testing. If the required data has been properly
		/// entered the OK button is enabled allowing user to continue.
		/// </summary>
		public bool IsReadyToSave()
		{
			bool ready = false;

			if (this._dtAntibodies == null)
				return true;

			if (_selectedAntibodies > 0 ||
				this.cbNoAntibody.Checked == true)
			{
				ready = true;

				if (this.cbOffSite.Checked == true)
				{
					if (this.txtLocation.Text.Trim() != "")
					{
						try
						{
							if (this.updCost.Value > 0)
							{
								ready =  true;
							}
							else
							{
								return false;
							}
						}
						catch(FormatException)
						{
							return false;
						}
					}
					else
					{
						return false;
					}
				}
				
				if (this.cbOnSite.Checked == true)
				{
					if (_selectedProcesses > 0)
					{
						ready = true;
					}
					else
					{
						return false;
					}
				}

				if (this.cbOffSite.Checked == false &&
					this.cbOnSite.Checked == false)
				{
					return false;
				}
			}

			return ready;
		}

		/// <summary>
		///     Property that exposes the workload processids that they associated with the patient testing
		/// </summary>
		/// <value>
		///     <para>
		///         
		///     </para>
		/// </value>
		/// <remarks>
		///     
		/// </remarks>
		public ArrayList WorkloadProcessIds 
		{
			get
			{
				return this._workloadProcessIds;
			}
		}

		/// <summary>
		/// Creates the DataTable for ABID testing. The datatable is a placeholder for test
		/// results and the related information. Used by UC56 to save test results to the 
		/// database.
		/// </summary>
		public DataTable CreateAntibodyIDTable()
		{
			this._dtAntibodyIDs = new DataTable("ABID");
			this._dtAntibodyIDs.Columns.Add(TABLE.AntibodyType.AntibodyTypeId, typeof(int));
			this._dtAntibodyIDs.Columns.Add(TABLE.AntibodyType.AntibodyTypeName);
			this._dtAntibodyIDs.Columns.Add(TABLE.SpecimenTest.OffsiteIndicator, typeof(bool));
			this._dtAntibodyIDs.Columns.Add(TABLE.SpecimenTest.OffsiteLocation);
			this._dtAntibodyIDs.Columns.Add(TABLE.SpecimenTest.OffsiteCost, typeof(decimal));
			this._dtAntibodyIDs.Columns.Add(TABLE.SpecimenTest.CannedCommentGuid, typeof(Guid));
			this._dtAntibodyIDs.Columns.Add(TABLE.SpecimenTest.TestComments);
			this._dtAntibodyIDs.Columns.Add(TABLE.SpecimenTest.OrderedTestGuid, typeof(Guid));
			this._dtAntibodyIDs.Columns.Add(TABLE.SpecimenTest.PatientSpecimenGuid, typeof(Guid));
			this._dtAntibodyIDs.Columns.Add(TABLE.SpecimenTest.CorrectedResultIndicator, typeof(bool));
			this._dtAntibodyIDs.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			this._dtAntibodyIDs.Columns.Add(TABLE.Patient.PatientGuid, typeof(Guid));
			this._dtAntibodyIDs.Columns.Add(TABLE.OrderableTest.OrderableTestId, typeof(int));

			return this._dtAntibodyIDs;
		}


		/// <summary>
		/// Sets the ordered test for ABID testing
		/// </summary>
		public BOL.OrderedTest OrderedTest
		{
			set
			{
				this._orderedTest = value;
			}
		}

		#endregion

		#region Control Events

		private void cbOffSite_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.cbOffSite.Checked == true)
				this.grpOffSite.Enabled = true;
			else
				this.grpOffSite.Enabled = false;

			OnDataChanged(EventArgs.Empty);
		}

		private void cbOnSite_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.cbOnSite.Checked == true)
			{
				this.grpOnSite.Enabled = true;
				if (this.cmbWorkloadProcess.SelectedIndex != -1)
					this.btnAdd.Enabled = true;
				else
					this.btnAdd.Enabled = false;
			}
			else
				this.grpOnSite.Enabled = false;

			OnDataChanged(EventArgs.Empty);
		}

		private void lstAntibodyID_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (e.NewValue == CheckState.Checked)
			{
				_selectedAntibodies++;
				this.grpComments.Enabled = true;
			}
			else if (e.NewValue == CheckState.Unchecked)
			{
				_selectedAntibodies--;

				if (_selectedAntibodies == 0)
					this.grpComments.Enabled = false;
			}

			OnDataChanged(EventArgs.Empty);
		}

		private void txtLocation_TextChanged(object sender, System.EventArgs e)
		{
			OnDataChanged(EventArgs.Empty);
		}

		private void updCost_ValueChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (this.updCost.Value > 0)
				{
					this.errError.SetVbecsError(updCost, string.Empty); // **** 508 Compliance ***
				}
			}
			catch(FormatException)
			{
				//
			}
			OnDataChanged(EventArgs.Empty);
		}

		private void updCost_Leave(object sender, System.EventArgs e)
		{
			try
			{
				this.updCost.Value = this.updCost.Value;
				this.errError.SetVbecsError(updCost, string.Empty); // **** 508 Compliance ***
			}
			catch(FormatException err)
			{
				this.errError.SetVbecsError(updCost, err.Message); // **** 508 Compliance ***
			}
			OnDataChanged(EventArgs.Empty);
		}

		private void btnAdd_Click(object sender, System.EventArgs e)
		{
			if (CheckWorkloadValid())
			{
				ListViewItem lvItem = new ListViewItem();
				lvItem.SubItems.Add(this.cmbWorkloadProcess.Text);
				lvItem.SubItems.Add(this.updMultiples.Value.ToString());
				lvItem.Tag = this._dtVbecsProcesses.Rows[this.cmbWorkloadProcess.SelectedIndex][0];
				lvItem.Checked = true;
				this.lvWorkloadProcesses.Items.Add(lvItem);
				OnDataChanged(EventArgs.Empty);
			}
		}

		private void lvWorkloadProcesses_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (e.NewValue == CheckState.Checked)
				_selectedProcesses++;
			else if (e.NewValue == CheckState.Unchecked)
				_selectedProcesses--;

			OnDataChanged(EventArgs.Empty);
		}

		private void cbNoAntibody_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.cbNoAntibody.Checked == true)
			{
				this.lstAntibodyID.Enabled = false;
				this.txtAntibodyID.Enabled = false;

				this.grpComments.Enabled = true;
			}
			else
			{
				this.lstAntibodyID.Enabled = true;
				this.txtAntibodyID.Enabled = true;

				if (this.lstAntibodyID.CheckedItems.Count > 0)
					this.grpComments.Enabled = true;
				else
					this.grpComments.Enabled = false;
			}
			OnDataChanged(EventArgs.Empty);
		}

		private void txtAntibodyID_TextChanged(object sender, System.EventArgs e)
		{
			for (int i=0; i<this.lstAntibodyID.Items.Count; i++)
			{
				if (this.lstAntibodyID.Items[i].ToString().StartsWith(this.txtAntibodyID.Text.Trim()) == true)
				{
					this.lstAntibodyID.SetSelected(i, true);
					this.txtAntibodyID.Select(this.txtAntibodyID.Text.Length, 0);
					this.txtAntibodyID.Focus();
					break;
				}
			}
//			int index = this.lstAntibodyID.Items.IndexOf(this.txtAntibodyID.Text.Trim());
//			if (index != -1)
//			{
//				this.lstAntibodyID.SetSelected(index, true);
//				this.txtAntibodyID.Select(this.txtAntibodyID.Text.Length, 0);
//				this.txtAntibodyID.Focus();
//			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>07/17/2002</CreationDate>
		///
		/// <summary>
		/// Numeric up/down text changed event handler. 
		/// Does not allow non integer inputs
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">System.EventArgs</param>
		private void updMultiples_TextChanged(object sender, System.EventArgs e)
		{
			try
			{
				this.updMultiples.Value = (int) this.updMultiples.Value;
				this.errError.SetVbecsError(updMultiples, string.Empty); // **** 508 Compliance ***
				_validMultiplier = true;
			}
			catch(FormatException)
			{
				_validMultiplier = false;
			}
			btnAdd.Enabled = CheckWorkloadValid();
		}

		private void updMultiples_Leave(object sender, EventArgs e)
		{
			try
			{
				this.updMultiples.Value = (int) this.updMultiples.Value;
				this.errError.SetVbecsError(updMultiples, string.Empty); // **** 508 Compliance ***
				_validMultiplier = true;
			}
			catch(FormatException err)
			{
				this.errError.SetVbecsError(updMultiples, err.Message); // **** 508 Compliance ***
				_validMultiplier = false;
			}
			btnAdd.Enabled = CheckWorkloadValid();
		}

		private bool CheckWorkloadValid()
		{
			return ((this.cmbWorkloadProcess.SelectedIndex != -1)&&(_validMultiplier));
		}

		private void cmbWorkloadProcess_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			btnAdd.Enabled = CheckWorkloadValid();
		}
		/// <summary>
		/// **** 508 Compliance ***
		/// Get the error messages active for the control
		/// </summary>
		/// <returns></returns>
		public string GetErrorMessages()
		{
			return this.errError.GetErrorMessages();
		}

		#endregion

	}
}
